package auth

import (
	"bytes"
	"crypto/hmac"
	"crypto/sha1"
	"encoding/base64"
	"fmt"
	"strings"
	"time"
)

// 认证类型：普通认证；签名认证
type AuthType int

const (
	// 普通认证
	BasicAuth AuthType = iota
	// 签名认证
	SignAuth
)


type Authorize struct {
	uri            string
	contentMd5     string
	bucketName     string
	bucketPassword string
	method         string
	date           time.Time
	authType       AuthType
}

func (a *Authorize) DateStr() string {
	return a.date.Format("2006-01-02 15:04:05")
}

func (a *Authorize) Uri() string {
	return a.uri
}

func (a *Authorize) Method() string {
	return a.method
}

func NewAuthorize(uri , contentMd5 , bucketName , bucketPassword , method string, date time.Time, authType AuthType) *Authorize {
	return &Authorize{uri: uri, contentMd5: contentMd5, bucketName: bucketName, bucketPassword: bucketPassword, method: method, date: date, authType: authType}
}



// 用 & 拼接字符串
func (a *Authorize)buildSignature()string  {
	flag := "&"
	var buf bytes.Buffer

	buf.WriteString(string(a.method))
	buf.WriteString(flag)
	buf.WriteString(a.uri)
	buf.WriteString(flag)
	buf.WriteString(a.DateStr())
	buf.WriteString(flag)
	buf.WriteString(a.contentMd5)
	return strings.Trim(buf.String(), flag);
}
// 生成签名
func (a *Authorize)BuildAuthorize() string {
	if a.authType == BasicAuth{
		_str := a.bucketName+":"+a.bucketPassword;
		return "Basic "+ base64.StdEncoding.EncodeToString([]byte(_str))
	}
	// 用 & 拼接
	signatureStr := a.buildSignature()

	// 计算 sha1
	dst := base64.StdEncoding.EncodeToString([]byte(a.bucketPassword))
	hashHandler := hmac.New(sha1.New, []byte(dst));
	hashHandler.Write([]byte(signatureStr))

	// 输出 二进制再base64
	signature := base64.StdEncoding.EncodeToString(hashHandler.Sum(nil))

	// 签名
	return fmt.Sprintf(`WESTYUN %s:%s`, a.bucketName, signature)
}
